<?php

namespace App\Http\Livewire;

use App\Models\Certificado;
use Carbon\Carbon;
use DateTimeZone;
use Livewire\Component;

class Home extends Component
{
    public $fecha, $fullsello;
    public $cliente, $rut, $direccion, $comuna;
    public $fechaCalibracion, $sello, $vencimiento;
    public $tipoInstrumento, $lugar, $ubicacionEquipo, $marca, $modelo, $numeroSerie, $codigoInterno, $capMaxima, $escalafonReal, $escalafonVerificacion, $clasificacionExactitud;
    public $normaReferencia, $procedimientoInterno, $temperatura, $humedadRelativa;
    public $rangoPatron, $identificacionPatron, $certificadoCalibracion, $trazabilidad, $vigenciaPatron;

    public function updatedcliente()
    {
        $this->rut = '76.169.449-9';
        $this->direccion = 'ALONSO DE CORDOVA N° 4125 – PISO 8';
        $this->comuna = 'VITACURA - SANTIAGO';
    }

    public function updatedcodigoInterno()
    {
        $this->numeroSerie = 'N/A';
        $this->marca = 'TCS-SCALE';
        $this->tipoInstrumento = 'Balanza de Pedestal con Bluetooth';
        $this->ubicacionEquipo = 'Fundo ADQUE – San José de Mariquina - Valdivia';
        $this->modelo = 'TCS-60';
        $this->capMaxima = '60Kg';
        $this->escalafonReal = '10gr';
        $this->escalafonVerificacion = '10gr';
        $this->clasificacionExactitud = 'Clase III';
       
    }
    
    public function generarCertificado()
    {

    }

    public function Store()
    {
        $certificado = Certificado::create([
            'fecha' => $this->fecha,
            'fullsello' =>$this->fullsello,
            'cliente' => $this->cliente,
            'rut' => $this->rut,
            'direccion' => $this->direccion,
            'comuna' => $this->comuna,
            'fechaCalibracion' => $this->fechaCalibracion,
            'sello' => $this->sello,
            'vencimiento' => $this->vencimiento,
            'codigoInterno' => $this->codigoInterno,
            'numeroSerie' => $this->numeroSerie,
            'marca' => $this->marca,
            'tipoInstrumento' => $this->tipoInstrumento,
            'ubicacionEquipo' => $this->ubicacionEquipo,
            'lugar' => $this->lugar,
            'modelo' => $this->modelo,
            'capMaxima' => $this->capMaxima,
            'escalafonReal' => $this->escalafonReal,
            'escalafonVerificacion' => $this->escalafonVerificacion, 
            'clasificacionExactitud' => $this->clasificacionExactitud,
            'normaReferencia' => $this->normaReferencia,
            'procedimientoInterno' => $this->procedimientoInterno,
            'temperatura' => $this->temperatura,
            'humedadRelativa' => $this->humedadRelativa,
            'rangoPatron' => $this->rangoPatron,
            'identificacionPatron' => $this->identificacionPatron,
            'certificadoCalibracion' => $this->certificadoCalibracion,
            'trazabilidad' => $this->trazabilidad,
            'vigenciaPatron' => $this->vigenciaPatron,
        ]);

        $this->resetUI();
        $this->emit('added','Certificado Registrado');
    }

    public function resetUI()
    {
        $this->fullsello = '';
        $this->cliente = 'Elegir';
        $this->rut = '';
        $this->direccion = '';
        $this->comuna = '';
        $this->fechaCalibracion = '';
        $this->sello = '';
        $this->vencimiento = '';
        $this->codigoInterno = '';
        $this->numeroSerie = '';
        $this->marca = '';
        $this->tipoInstrumento = '';
        $this->ubicacionEquipo = '';
        $this->lugar = '';
        $this->modelo = '';
        $this->capMaxima = '';
        $this->escalafonReal = '';
        $this->escalafonVerificacion = '';
        $this->clasificacionExactitud = '';
        $this->normaReferencia = 'Elegir';
        $this->procedimientoInterno = 'Elegir';
        $this->temperatura = '';
        $this->humedadRelativa = '';
        $this->rangoPatron  = 'Elegir';
        $this->identificacionPatron = 'Elegir';
        $this->certificadoCalibracion = 'Elegir';
        $this->trazabilidad = 'Elegir';
        $this->vigenciaPatron = 'Elegir';
    }

    public function mount()
    {
        
        $date=Carbon::now()->locale('es_ES');
        setlocale(LC_ALL,'es_ES');
        // $this->fecha = date_format(now(), 'd-F-Y');
        $this->fecha = $date->isoFormat('LLL');
    }

    public function render()
    {
        
        return view('livewire.home');
    }
}
