<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Certificado extends Model
{
    use HasFactory;

    protected $fillable = [
        'fecha',
        'fullsello',
        'cliente',
        'rut',
        'direccion',
        'comuna',
        'fechaCalibracion',
        'sello',
        'vencimiento',
        'codigoInterno',
        'numeroSerie',
        'marca',
        'tipoInstrumento',
        'ubicacionEquipo',
        'lugar',
        'modelo',
        'capMaxima',
        'escalafonReal',
        'escalafonVerificacion',
        'clasificacionExactitud',
        'normaReferencia',
        'procedimientoInterno',
        'temperatura',
        'humedadRelativa',
        'rangoPatron',
        'identificacionPatron',
        'certificadoCalibracion',
        'trazabilidad',
        'vigenciaPatron',
    ];

    public function cliente()
    {
        return $this->belongsTo(Cliente::class);
    }
}
