
<!DOCTYPE html>
<html lang="en">
<head>

    @include('layouts.main.head')
    @livewireStyles

</head>
<body class="alt-menu sidebar-noneoverflow">

    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
       <div class="spinner-grow align-self-center"></div>
   </div></div></div>
   <!--  END LOADER -->

   <!--  BEGIN NAVBAR  -->
   <div class="header-container">
       @include('layouts.main.navbar')
   </div>
   <!--  END NAVBAR  -->
   <!--  BEGIN MAIN CONTAINER  -->
   <div class="main-container" id="container">

       <div class="overlay"></div>
       <div class="search-overlay"></div>

       <!--  BEGIN MENUBAR  -->
       @include('layouts.main.menubar')
       <!--  END MENUBAR  -->
       
       <!--  BEGIN CONTENT PART  -->
       <div id="content" class="main-content">
           <div class="layout-px-spacing">

               <div class="page-header">
                   <div class="page-title">
                       <h3>@yield('title')</h3>
                   </div>
               </div>

               <div class="row layout-top-spacing">
                <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                    <div class="widget-content widget-content-area br-6">
                        @yield('content')
                    </div>
                </div>
                <div class="footer-wrapper">
                    <div class="footer-section f-section-1">
                        <p class="">Copyright © {{ date('Y') }} <a target="_blank" href="#">RAPSystem</a>, Todos los derechos reservados.</p>
                    </div>
                    <div class="footer-section f-section-2">
                        <p class="">Coded with <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-heart"><path d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z"></path></svg></p>
                    </div>
                </div>
            </div>                            

           
       </div>
       <!--  END CONTENT PART  -->

   </div>
   <!-- END MAIN CONTAINER -->
   <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
   @include('layouts.main.js')
   <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM SCRIPTS -->
   @include('layouts.main.mensajes')
   @livewireScripts
</body>
</html>