<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Certificado</title>
    
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap/css/bootstrap.min.css')); ?>">

    <style>
        @page{
            margin: 1cm 1cm;
        }
        hr {
            width: 50%;
            margin-left: 25%;
            box-shadow: none;
            margin-top: 0;
            border-color: red;
        }

        td {
            padding-bottom: 3px;
        }
        h3{
            color: rgb(8, 7, 78);
        }

    </style>
</head>
<body>
    <div class="pb-3">
        <img src="<?php echo e(asset('logos/logo.png')); ?>" alt="no existe" width="200px" class="rounded">
    </div>

    <div class="container-fluid">
        <div class="row g-2 pb-4">
            <h2 class="text-center  pb-2">Certificado de Calibración</h2>
            <table class="">
                <tbody>
                    <td class="col-7"><b>Certificado N°:</b> <?php echo e($data->fullsello); ?> </td>
                    <td class="col-5 "><b>Fecha:</b> <?php echo e($data->fecha); ?></td>
                </tbody>
            </table>
        </div>
        <div class="row g-2 pb-3">
            <h3>Identificación del Cliente</h3>
            <table>
                <tr>
                    <td><b>Cliente:</b> <?php echo e($data->cliente); ?> </td>
                    <td><b>Rut:</b> <?php echo e($data->rut); ?></td>
                </tr>
                <tr>
                    <td><b>Dirección:</b> <?php echo e($data->direccion); ?></td>
                    <td><b>Comuna:</b> <?php echo e($data->comuna); ?></td>
                </tr>
            </table>
        </div>
        <div class="row g-2 pb-3">
            <h3>Correlación de Calibración</h3>
            <table>
                <tr>
                    <td><b>Fecha de Calibración:</b> <?php echo e($data->fechaCalibracion); ?></td>
                    <td><b>Vence:</b> <?php echo e($data->vencimiento); ?></td>
                </tr>
                <tr>
                    <td><b>Sello de Calibración:</b> <?php echo e($data->sello); ?></td>
                </tr>
            </table>
        </div>
        <div class="row g-2 pb-3">
            <h3>Identificación del Equipo</h3>
            <table class="">
                <tr>
                    <td colspan="2"><b>Tipo de instrumento:</b> <?php echo e($data->tipoInstrumento); ?></td>
                </tr>
                <tr>
                    <td colspan="2"><b>Ubicación del equipo:</b> <?php echo e($data->ubicacionEquipo); ?></td>
                </tr>
                <tr >
                    <td ><b>Lugar:</b> <?php echo e($data->lugar); ?></td>
                    <td ><b>Marca:</b> <?php echo e($data->marca); ?></td>
                </tr>
                <tr>
                    <td><b>Modelo:</b> <?php echo e($data->modelo); ?></td>
                    <td><b>N° Serie:</b> <?php echo e($data->numeroSerie); ?></td>
                </tr>
                <tr>
                    <td><b>Código Interno:</b> <?php echo e($data->codigoInterno); ?></td>
                    <td><b>Capacidad máxima:</b> <?php echo e($data->capMaxima); ?></td>
                </tr>
                <tr>
                    <td><b>Escalafón real (d):</b> <?php echo e($data->escalafonReal); ?></td>
                    <td><b>Escalafón de verificación (e):</b> <?php echo e($data->escalafonVerificacion); ?></td>
                </tr>
                <tr>
                    <td><b>Clasificación de Exactitud:</b> <?php echo e($data->clasificacionExactitud); ?></td>
                </tr>
            </table>
        </div>
        <div class="row justify-content-center  g-2 pb-3">
            <h3>Condiciones de Calibración</h3>
            <table class="row g-1" >
                <tr>
                    <td><b>Norma de Referencia:</b> <?php echo e($data->normaReferencia); ?></td>
                    <td><b>Procedimiento Interno:</b><?php echo e($data->procedimientoInterno); ?> </td>
                </tr>
                <tr>
                    <td><b>Temperatura (°C):</b> <?php echo e($data->temperatura); ?></td>
                    <td><b>Humedad relativa (%):</b><?php echo e($data->humedadRelativa); ?> </td>
                </tr>
            </table>
        </div>
        <div class="row justify-content-center  g-2 pb-3">
            <h3>Trazabilidad de Calibración</h3>
            <table class="row g-1" >
                <tr>
                    <td ><b>Rango Patrón Utilizado: </b><?php echo e($data->rangoPatron); ?></td>
                    <td ><b>Identificación de patrón:</b><?php echo e($data->identificacionPatron); ?></td>
                </tr>
                <tr>
                    <td ><b>Certificados Calibración:</b><?php echo e($data->certificadoCalibracion); ?></td>
                    <td ><b>Vigencia Patrón Utilizado:</b><?php echo e($data->vigenciaPatron); ?></td>
                </tr>
                <tr>
                    <td ><b>Trazabilidad:</b><?php echo e($data->trazabilidad); ?></td>
                </tr>

            </table>
        </div>
        <div class="row pb-3">
            <h4>Conformidad</h4>
            <table >
                <td><p>Los resultados de la calibración del instrumento antes identificado, cumplen con los principales  requerimientos metrológicos establecidos en la norma  de OIML R76-1. (Organización Internacional de Metrología legal).</p>
                </td>
            </table>
        </div>
    </div>

    <div class="text-center pt-2 pb-3">
        <img src="<?php echo e(asset('logos/logo2.png')); ?>" alt="no existe" width="200px" class="rounded">
    </div>
    <div class="text-center">
        <h4>ORREGO LUCO 1227 - RANCAGUA  FONO   Cel. 9-93481710</h4>

        <hr class="">

        <h4><b>Email: servitecnoiso9001@gmail.com</b></h4>
    </div>

    
    
</body>
</html>
<?php /**PATH F:\www\servitecno\resources\views/pdf/pdf.blade.php ENDPATH**/ ?>